<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StreamScheduledItem extends Model 
{

    protected $table = 'stream_scheduled_item';
    public $timestamps = true;
    protected $fillable = array('stream_id', 'component_playlist_id', 'ordering', 'def', 'date_from', 'date_to', 'time_from', 'time_to', 'dow', 'shuffle');

    public function stream()
    {
        return $this->belongsTo('App\Models\Stream');
    }

    public function componentPlaylist()
    {
        return $this->belongsTo('App\Models\ComponentPlaylist');
    }

}